//
//  barcodeQR.m
//  POSSDKForIOS 2013-07-31(2)
//
//  Created by liangchenying on 12-4-15.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "barcodeQR.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface barcodeQR()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation barcodeQR
@synthesize Back;
@synthesize QRData;
@synthesize BasicElementWidthButton;
@synthesize SymbolTypeButton;
@synthesize LanguageModeButton;
@synthesize Cut;
@synthesize Print;

@synthesize pos_sdk		              = _pos_sdk;

@synthesize array_BasicElementWidth	  = _array_BasicElementWidth;
@synthesize array_SymbolType          = _array_SymbolType;
@synthesize array_LanguageMode	      = _array_LanguageMode;

@synthesize selectedBasicElementWidth = _selectedBasicElementWidth;
@synthesize selectedSymbolType	      = _selectedSymbolType;
@synthesize selectedLanguageMode	  = _selectedLanguageMode;

- (NSMutableArray*)array_BasicElementWidth
{
    if(_array_BasicElementWidth  == nil)
    {
        _array_BasicElementWidth = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_BasicElementWidth;
}

- (NSMutableArray*)array_SymbolType
{
    if(_array_SymbolType  == nil)
    {
        _array_SymbolType = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_SymbolType;
}

- (NSMutableArray*)array_LanguageMode
{
    if(_array_LanguageMode  == nil)
    {
        _array_LanguageMode = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_LanguageMode;
}


- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (NSInteger)NSArrayToInt:(NSMutableArray *)Array Index:(NSInteger)Index
{
    NSInteger INT;
    NSString *String = nil;
    String=[Array objectAtIndex:Index];
    INT = [String intValue];
    return INT;
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_BasicElementWidth
        [self.array_BasicElementWidth addObject:@"1"];
        [self.array_BasicElementWidth addObject:@"2"];
        [self.array_BasicElementWidth addObject:@"3"];
        [self.array_BasicElementWidth addObject:@"4"];
        [self.array_BasicElementWidth addObject:@"5"]; 
        [self.array_BasicElementWidth addObject:@"6"];
        [self.array_BasicElementWidth addObject:@"7"];
        [self.array_BasicElementWidth addObject:@"8"]; 
        [self.array_BasicElementWidth addObject:@"9"];
        [self.array_BasicElementWidth addObject:@"10"];

        //**************************************************************************************************
        //Add object for array_SymbolType
        [self.array_SymbolType addObject:@"Original Type"];
        [self.array_SymbolType addObject:@"Enhanced Type"];

        //**************************************************************************************************
        //Add object for array_LanguageMode
        [self.array_LanguageMode addObject:@"Chinese"];
        [self.array_LanguageMode addObject:@"Japanese"];
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.selectedBasicElementWidth = 4;
    self.selectedSymbolType        = 1;
    self.selectedLanguageMode      = 0;
    
    [self.QRData setDelegate:self];
    
    [self.BasicElementWidthButton setTitle:@"5" forState:UIControlStateNormal];
    [self.SymbolTypeButton        setTitle:@"Enhanced Type" forState:UIControlStateNormal];
    [self.LanguageModeButton      setTitle:@"Chinese" forState:UIControlStateNormal];
    
    [self.QRData setText:@"QA,AABCDEFGHIJKLMN1234567890"];
}

- (void)viewDidUnload
{
    [self setBack:nil];
    [self setQRData:nil];
    [self setBasicElementWidthButton:nil];
    [self setSymbolTypeButton:nil];
    [self setLanguageModeButton:nil];
    [self setCut:nil];
    [self setPrint:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Get Basic Element Width Index
- (IBAction)selectBasicElementWidth:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedBasicElementWidth = selectedIndex;   
        [BasicElementWidthButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Basic Element Width" Sheet:self.array_BasicElementWidth Selected:self.selectedBasicElementWidth DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Symbol Type Index
- (IBAction)selectSymbolType:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedSymbolType = selectedIndex;    
        [SymbolTypeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Symbol Type" Sheet:self.array_SymbolType Selected:self.selectedSymbolType DoneButton:done CancelButton:cancel Action:sender];
 }

//**************************************************************************************************
//Get Language Mode Index
- (IBAction)selectLanguageMode:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedLanguageMode = selectedIndex; 
        [LanguageModeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Language Mode" Sheet:self.array_LanguageMode Selected:self.selectedLanguageMode DoneButton:done CancelButton:cancel Action:sender];
}

//*************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.QRData resignFirstResponder];
        return NO;
    } 
    return YES;
}

//*************************************************************************************************
//Cut Paper
- (IBAction)Cut:(id)sender
{
    SInt32 error_code = SUCCESS;
    
   error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:80];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
ExitLine:
    return;
}

//*************************************************************************************************
//Print QR 
- (IBAction)QRPrint:(id)sender 
{
    //**************************************************************************************************
    //Initilize 
    SInt32 error_code          = SUCCESS;
    SInt32 basic_element_width = 0;
    SInt32 symbol_type         = 0;
    SInt32 language_mode       = 0;
    NSData *textNSData         = nil;
	
    //**************************************************************************************************
    //If Data == nil ,barcode cannot be printed.
    JudgeParamNil(QRData, @"Data == nil,Please input data");
    
    //**************************************************************************************************
    //Get every param
	NSStringEncoding enc= CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingGB_18030_2000);
	textNSData = [QRData.text dataUsingEncoding:enc];

    basic_element_width = [self NSArrayToInt:self.array_BasicElementWidth Index:self.selectedBasicElementWidth];
  
    if(self.selectedSymbolType == 0)           symbol_type = OriginalType;
    else if(self.selectedSymbolType == 1)      symbol_type = EnhancedType;
    
    if(self.selectedLanguageMode == 0)          language_mode = LanguageChinese;
    else if(self.selectedLanguageMode == 1)     language_mode = LanguageJapanese ;
    
    //**************************************************************************************************
    //print QR by calling the method "barcodePrintQR:"
    error_code = [self.pos_sdk barcodePrintQR:textNSData BasicElementWidth:basic_element_width SymbolType:symbol_type LanguageMode:language_mode];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //if print QR Success,feed line
    error_code = [self.pos_sdk systemFeedLine:2];      
    
ExitLine:
    return;
}

//*************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)dealloc
{
    [self.Back release];
    [self.QRData release];
    [self.BasicElementWidthButton release];
    [self.array_BasicElementWidth release];
    [self.array_SymbolType release];
    [self.array_LanguageMode release];
    [self.SymbolTypeButton release];
    [self.LanguageModeButton release];
    [self.Cut release];
    [self.Print release];
    [super dealloc];
}

@end
